/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.base.UnicodeFormatter;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class StringUtils {
    public static String _get_FILE_DATE() {
        return "$Date:   05 Sep 2006 11:21:54  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.5  $";
    }

    public static String[] split(String s, String delim) {
        if (s == null || s.length() == 0) {
            return null;
        }
        if (delim == null || s.indexOf(delim) == -1) {
            return new String[]{s};
        }
        StringTokenizer tk = new StringTokenizer(s, delim);
        ArrayList<String> v = new ArrayList<String>();
        while (tk.hasMoreTokens()) {
            v.add(tk.nextToken());
        }
        return v.toArray(new String[0]);
    }

    public static String hexEncode(byte[] input) {
        StringBuffer sb = new StringBuffer();
        if (input == null) {
            sb.append("null");
        } else {
            for (int i = 0; i < input.length; ++i) {
                String oneByte = Integer.toHexString(input[i] & 0xFF);
                if (1 == oneByte.length()) {
                    sb.append('0');
                }
                sb.append(oneByte);
            }
        }
        return sb.toString();
    }

    public static String printBytes(String s, String encoding) {
        try {
            if (encoding == null) {
                encoding = "UTF-8";
            }
            byte[] b = s.getBytes(encoding);
            StringBuffer buf = new StringBuffer();
            buf.append(encoding).append(" of ").append(s).append("=");
            int n = b == null ? 0 : b.length;
            for (int k = 0; k < n; ++k) {
                buf.append(" 0x").append(UnicodeFormatter.byteToHex(b[k]));
            }
            return buf.toString();
        }
        catch (Exception e) {
            return s;
        }
    }

    public static void main(String[] args) {
        String[] res;
        if (args.length < 1) {
            System.out.println("Usage:  StringUtils string [delim]");
            System.exit(1);
        }
        String delim = null;
        if (args.length > 1) {
            delim = args[1];
        }
        if ((res = StringUtils.split(args[0], delim)) != null) {
            int nItems = res.length;
            for (int i = 0; i < nItems; ++i) {
                System.out.println(res[i]);
            }
        }
    }
}

